﻿//////////////////////////////////////////////
// DofComplexEffectInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class Texture ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	struct DofComplexEffectInfo
	{
		// Input texture
		nkGraphics::Texture* _sourceTexture = nullptr ;
		nkGraphics::Texture* _sourceDepth = nullptr ;

		// Camera to track
		nkGraphics::Camera* _camera = nullptr ;

		// Focal info params
		float _nearBlurDistance = 10.f ;
		float _focalPlaneDistance = 50.f ;
		float _focalPlaneThickness = 0.f ;
		float _farBlurDistance = 100.f ;

		// Blurring params
		unsigned int _blurStrength = 3u ;

		// Flags for rendering methods
		bool _linearDepth = false ;
	} ;
}